/*import 'package:flutter/material.dart';

class PedidoWidget extends StatefulWidget {
  @override
  _PedidoWidgetState createState() => _PedidoWidgetState();
}

class _PedidoWidgetState extends State<PedidoWidget> {
  bool isExpanded = false; // Variable para controlar si el contenido está expandido

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(top: 18.0),
      child: Card(
        margin: EdgeInsets.all(16.0),
        child: ListView(
          shrinkWrap: true,
          children: <Widget>[
            Row(
              children: <Widget>[
                Text(
                  'CL000####, ',
                  style: TextStyle(fontSize: 16),
                ),
                Text(
                  'NO:0000## ',
                  style: TextStyle(fontSize: 16),
                ),
                Text(
                  'Q567.00',
                  style: TextStyle(fontSize: 16),
                ),
              ],
            ),
            InkWell(
              onTap: () {
                setState(() {
                  isExpanded = !isExpanded; // Cambia el estado del colapso
                });
              },
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text(
                    'FRUETALLE JUICE BAR',
                    style: TextStyle(fontSize: 20),
                  ),
                  Icon(
                    isExpanded ? Icons.arrow_drop_up : Icons.arrow_drop_down,
                    color: Colors.blue,
                  ),
                ],
              ),
            ),
            if (isExpanded)
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    'TEL: ####',
                    style: TextStyle(fontSize: 16),
                  ),
                  Text(
                    'DIRECCION: C.C. SPACIO MISTURA Z15',
                    style: TextStyle(fontSize: 16),
                  ),
                  Text(
                    'PRODUCTOS: LISTA DE PRODUCTOS INVENTADOS',
                    style: TextStyle(fontSize: 16),
                  ),
                ],
              ),
          ],
        ),
      ),
    );
  }
}*/ 

//-----------------------------------------------------------------------------------------

import 'package:app_corp_cliente/presentation/class/detalle.dart';
import 'package:app_corp_cliente/presentation/class/pedido.dart';
import 'package:flutter/material.dart';

class PedidoWidget extends StatefulWidget {
  final PedidoData data;

  PedidoWidget({required this.data, required PedidoData pedido});

  @override
  _PedidoWidgetState createState() => _PedidoWidgetState();
}

class _PedidoWidgetState extends State<PedidoWidget> {
  bool isExpanded = false;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.only(top: 18.0),
      child: Card(
        margin: EdgeInsets.all(16.0),
        child: ListView(
          shrinkWrap: true,
          children: <Widget>[
            ListTile(
              title: Text(
                '${widget.data.code}, ${widget.data.numeroOrden}, ${widget.data.total}',
                style: TextStyle(fontSize: 16),
              ),
              onTap: () {
                setState(() {
                  isExpanded = !isExpanded;
                });
              },
              trailing: Icon(
                isExpanded ? Icons.arrow_drop_up : Icons.arrow_drop_down,
                color: Colors.blue,
              ),
            ),
            if (isExpanded)
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    widget.data.nombreTienda,
                    style: TextStyle(fontSize: 20),
                  ),
                  Text(
                    widget.data.telefono,
                    style: TextStyle(fontSize: 16),
                  ),
                  Text(
                    widget.data.direccion,
                    style: TextStyle(fontSize: 16),
                  ),
                  Column(
                children: <Widget>[
                  Text('PRODUCTOS:', style: TextStyle(fontSize: 16)),
                  for (Detalle detalle in widget.data.productos)
                    Column(
                      children: [
                        Text('Código de Producto: ${detalle.codigoProducto}', style: TextStyle(fontSize: 16)),
                        Text('Nombre de Producto: ${detalle.nombreProducto}', style: TextStyle(fontSize: 16)),
                        Text('Cantidad: ${detalle.cantidad}', style: TextStyle(fontSize: 16)),
                        Text('Precio: ${detalle.precio}', style: TextStyle(fontSize: 16)),
                        Text('Subtotal: ${detalle.subtotal}', style: TextStyle(fontSize: 16)),
                        SizedBox(height: 10), // Espacio en blanco entre productos
                      ],
                    ),
                ],
),

                ],
              ),
          ],
        ),
      ),
    );
  }
}


