import 'package:app_corp_cliente/presentation/class/clientview.dart';
import 'package:app_corp_cliente/presentation/class/document.dart';
import 'package:flutter/material.dart';

class ActivityCliente extends StatelessWidget {
  final ClienteInformacion clienteInfo; // Datos del cliente
  final List<DocumentoCliente> documentos; // Lista de documentos del cliente

  ActivityCliente({required this.clienteInfo, required this.documentos});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('Cliente Details'),
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Container(
              width: double.infinity,
              margin: EdgeInsets.only(bottom: 16.0),
              child: Card(
                child: Padding(
                  padding: const EdgeInsets.all(16.0),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text('CLIENTE:', style: TextStyle(fontSize: 22)),
                      Text(clienteInfo.nombre, style: TextStyle(fontSize: 25)),
                    ],
                  ),
                ),
              ),
            ),
            SizedBox(height: 16),
            Card(
              child: ExpansionTile(
                title: Padding(
                  padding: const EdgeInsets.only(left: 16.0, bottom: 8.0),
                  child: Text(
                    'Información',
                    style: TextStyle(fontSize: 28),
                  ),
                ),
                children: <Widget>[
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text('ID: ${clienteInfo.id}', style: TextStyle(fontSize: 20)),
                      Text('NOMBRE: ${clienteInfo.nombre}', style: TextStyle(fontSize: 20)),
                      Text('HORARIO: ${clienteInfo.horario}', style: TextStyle(fontSize: 20)),
                      Text('DIRECCIÓN: ${clienteInfo.direccion}', style: TextStyle(fontSize: 20)),
                      Text('LIQUIDACIÓN: ${clienteInfo.liquidacion}', style: TextStyle(fontSize: 20)),
                      Text('TIPO DE COBRO: ${clienteInfo.tipoDeCobro}', style: TextStyle(fontSize: 20)),
                    ],
                  ),
                ],
              ),
            ),
Card(
  child: ExpansionTile(
    title: Padding(
      padding: const EdgeInsets.only(left: 16.0, bottom: 8.0),
      child: Text(
        'DOCUMENTOS',
        style: TextStyle(fontSize: 28),
      ),
    ),
    children: documentos.map((doc) {
      Color cardColor = doc.liquidado ? const Color.fromARGB(255, 175, 255, 178) : const Color.fromARGB(255, 240, 148, 141); // Color verde si liquidado, rojo si no

      return Card(
        color: cardColor, // Aplicar el color
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: <Widget>[
                Text('Factura: ', style: TextStyle(fontSize: 20)),
                Text(doc.factura, style: TextStyle(fontSize: 20)),
                SizedBox(width: 16), // Espacio entre los campos
                Text('Valor: ', style: TextStyle(fontSize: 20)),
                Text(doc.valor, style: TextStyle(fontSize: 20)),
                SizedBox(width: 16), // Espacio entre los campo
              ],
            ),
          ],
        ),
      );
    }).toList(),
  ),
),


            SizedBox(height: 16),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: <Widget>[
                ElevatedButton(
                  onPressed: () {
                    // Acción para editar
                  },
                  child: Text('Editar'),
                ),
                SizedBox(width: 15),
                ElevatedButton(
                  onPressed: () {
                    // Acción para GPS
                  },
                  child: Text('GPS'),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
