import 'package:app_corp_cliente/presentation/class/detalle.dart';
import 'package:app_corp_cliente/presentation/screens/pedido.dart';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';

import '../class/pedido.dart';


class Spedido extends StatefulWidget {

   String message = '';

  Spedido({super.key});
  

  @override
  _SpedidoState createState() => _SpedidoState();
}

class _SpedidoState extends State<Spedido> {
  String message = ''; // Variable para el mensaje que se mostrará.
List<PedidoData> pedidos = [];
  @override
  void initState() {
    super.initState();
    _fetchDataFromUrl(context);
  }

  Future<void> _fetchDataFromUrl(BuildContext context) async {
    try {
      final response = await http.get(Uri.parse(
            'http://appcorp.dev.parma.gt/API/ReceptorDatos?Datos=%7B%09%22Token%22%3A%22LJKNFUH2FWEJBAEFFFFFKJ%20VGDEA003CSFCAQWEUIRRRRRRRRRRRADFYGBIFHVBESRNYHIOPWJROTY4WY%22%2C%20%09%22Ambiente%22%3A%22DESA%22%2C%20%09%22Dispositivo%22%3A%7B%20%09%09%22Marca%22%3A%22SAMSUNG%22%2C%20%09%09%22Modelo%22%3A%22S22002B%22%2C%20%09%09%22Version%22%3A%22Android%2018.125%22%2C%20%09%09%22McAdress%22%3Anull%2C%20%09%09%22PowerStatus%22%3A%2284%25%22%2C%20%09%09%22WifiStatus%22%3A%22Conected%20to%20iphone%20de%20Mauricio%22%2C%20%09%09%22GPSStatus%22%3A%22ON%22%2C%20%09%09%22GPS%22%3A%22321%7C-485%7C321%22%7D%2C%20%09%22Usr%22%3A%7B%20%09%09%22Codigo%22%20%3A%20%221%22%2C%20%09%09%22UserNickName%22%3A%22pierril%22%2C%20%09%09%22UserPassword%22%3Anull%2C%20%09%09%22UserNombre%22%3Anull%2C%20%09%09%22Ubicaciones%22%3A%20null%2C%20%09%09%22Menus%22%3Anull%7D%2C%20%09%22DatosMetodo%22%3A%7B%20%09%09%22NombreMetodo%22%3A%22ListaPedidosVendedor%22%2C%20%09%09%22Datos_Recibidos%22%3A%22%7B%5C%22Codigo%5C%22%3A%5C%221%5C%22%2C%5C%22Usuario%5C%22%3A%5C%22lpierri%5C%22%7D%22%2C%20%09%09%22Datos_Generados%22%3A%22%22%7D%7D'
        ));

      if (response.statusCode == 200) {
        // Analizar la respuesta JSON y realizar cualquier otro procesamiento necesario.
        final responseData = json.decode(response.body);
        final datosg = responseData['datosMetodo'];
        final datosm = datosg['datos_Generados'];
        final datosGenerados = json.decode(datosm);
        final datosf = datosGenerados['PEDIDOS'];
        
        print(datosm);
        print(datosf);


 
 //   final datosGenerados = json.decode(datosm);
    if (datosf is List) {
      print('Datos Generados:');
      
      for (var datos in datosf) {
         print(datos['DETALLE']);  

      final dmg = datos['DETALLE'];
      print(dmg);
      List<Map<String, dynamic>> listaDeDetalles = (datos['DETALLE'] as List).cast<Map<String, dynamic>>();

     List<Detalle> nuevaLista = [];

      for (var objeto in listaDeDetalles) {
        Detalle nuevoObjeto = Detalle(
          codigoProducto: objeto['CodigoProducto'],
          nombreProducto: objeto['NombreProducto'],
          cantidad: objeto['Cantidad'],
          precio: objeto['Precio'],
          subtotal: objeto['Subtotal'],
        );
        nuevaLista.add(nuevoObjeto);
      }


          print(nuevaLista);


        final pedido = PedidoData(
          code: datos['CodigoCliente'],
          numeroOrden: datos['CodigoPedido'].toString(),
          total: datos['Total'],
          telefono: datos['Telefono1'], 
          nombreTienda: datos['NombreCliente'],
          direccion: datos['DireccionFiscal'],
          productos: nuevaLista, 
           
        );
        pedidos.add(pedido);
      }
    } else {
      print('Datos Generados no es una lista válida.');
    }
 



        // Cambiar el mensaje que se mostrará en la interfaz de usuario.
        setState(() {
          message = '¡Petición exitosa!'; // Puedes personalizar este mensaje.
        });
     
      } else {
        print('Error en la solicitud HTTP: ${response.statusCode}');
      }
    } catch (e) {
      print('Excepción: $e');
    }
  }

   @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          if (message.isEmpty)
            CircularProgressIndicator()
          else
            Expanded(
              child: ListView.builder(
                itemCount: pedidos.length,
                itemBuilder: (context, index) {
                  final pedido = pedidos[index];
                  return PedidoWidget(data: pedido, pedido:pedido,);
                },
              ),
            ),
        ],
      ),
    );
  }
}


