import 'dart:io';

import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';

import '../class/cliente.dart';
import '../screens/card.dart';

class Sclient extends StatefulWidget {

   String message = '';
  

  @override
  _SclientState createState() => _SclientState();
}

class _SclientState extends State<Sclient> {
  String message = ''; // Variable para el mensaje que se mostrará.
List<Client> clients = [];
  @override
  void initState() {
    super.initState();
    _fetchDataFromUrl(context);
  }

Future<void> _fetchDataFromUrl(BuildContext context) async {
  try {

     final client = HttpClient();
    client.badCertificateCallback = (X509Certificate cert, String host, int port) {
    print('Deshabilitando verificación de certificado SSL.');
    return true; // Deshabilita la verificación del certificado
  };
    final url = Uri.parse(
      'http://appcorp.dev.parma.gt/API/ReceptorDatos?Datos=%7B%22Token%22%3A%22LJKNFUH2FWEJBAEFFFFFKJ%20VGDEA003CSFCAQWEUIRRRRRRRRRRRADFYGBIFHVBESRNYHIOPWJROTY4WY%22%2C%22Ambiente%22%3A%22DESA%22%2C%22Dispositivo%22%3A%7B%22Marca%22%3A%22SAMSUNG%22%2C%22Modelo%22%3A%22S22002B%22%2C%22Version%22%3A%22Android%2018.125%22%2C%22McAdress%22%3Anull%2C%22PowerStatus%22%3A%2284%25%22%2C%22WifiStatus%22%3A%22Conected%20to%20iphone%20de%20Mauricio%22%2C%22GPSStatus%22%3A%22ON%22%2C%22GPS%22%3A%22321%7C-485%7C321%22%7D%2C%22Usr%22%3A%7B%22Codigo%22%3A%222165%22%2C%22UserNickName%22%3A%22pierril%22%2C%22UserPassword%22%3Anull%2C%22UserNombre%22%3Anull%2C%22Ubicaciones%22%3Anull%2C%22Menus%22%3Anull%7D%2C%22DatosMetodo%22%3A%7B%22NombreMetodo%22%3A%22Lista_Clientes%22%2C%22Datos_Recibidos%22%3A%22%7B%5C%22Codigo%5C%22%3A%5C%222165%5C%22%2C%5C%22Usuario%5C%22%3A%5C%22lpierri%5C%22%7D%22%2C%22Datos_Generados%22%3A%22%22%7D%7D',
    );

   

    final request = await client.getUrl(url);
    final response = await request.close();

    if (response.statusCode == 200) {
      final responseBody = await response.transform(utf8.decoder).join();
      final responseData = json.decode(responseBody);
      final datosg = responseData['datosMetodo'];
      final datosm = datosg['datos_Generados'];
      print(datosm);

      if (datosm != null) {
        if (datosm is String) {
          final datosGenerados = json.decode(datosm);
          if (datosGenerados is List) {
            print('Datos Generados:');
            for (var datos in datosGenerados) {
              final client = Client(
                code: datos['codigo'],
                title: datos['Nombre'],
                address: datos['DireccionFiscal'],
                phone: datos['Telefono1'],
              );
              clients.add(client);
            }
          } else {
            print('Datos Generados no es una lista válida.');
          }
        } else {
          print('Datos Generados no es una cadena válida.');
        }
      } else {
        print('No se encontraron datos generados en la respuesta.');
      }

      // Cambiar el mensaje que se mostrará en la interfaz de usuario.
      setState(() {
        message = '¡Petición exitosa!';
      });
    } else {
      print('Error en la solicitud HTTP: ${response.statusCode}');
    }
  } catch (e) {
    print('Excepción: $e');
  }
}




   @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: <Widget>[
          if (message.isEmpty)
            CircularProgressIndicator()
          else
            Expanded(
              child: ListView.builder(
                itemCount: clients.length,
                itemBuilder: (context, index) {
                  final client = clients[index];
                  return CardClient(client: client);
                },
              ),
            ),
        ],
      ),
    );
  }
}


